/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.exporters;

import LegendaryCardMaker.CustomCardMaker.structure.CustomCard;
import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import LegendaryCardMaker.CustomCardMaker.structure.ElementBackgroundImage;
import LegendaryCardMaker.CustomCardMaker.structure.ElementImage;
import LegendaryCardMaker.LegendaryCardMaker;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryHeroMaker.Hero;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCard;
import LegendaryCardMaker.LegendaryVillainMaker.Villain;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCard;
import LegendaryCardMaker.exporters.ZipperHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class ExportFullProgressBarDialog
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JProgressBar progressBar;
    private Task task;
    private int maxValue;
    private int currentValue;
    private LegendaryCardMaker lcm;
    private File folder;
    private JDialog frame;

    public ExportFullProgressBarDialog(int maxValue, LegendaryCardMaker lcm, File folder) {
        super(new BorderLayout());
        this.lcm = lcm;
        this.folder = folder;
        this.maxValue = maxValue;
        this.progressBar = new JProgressBar(0, maxValue);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        JPanel panel = new JPanel();
        panel.add(this.progressBar);
        this.add((Component)panel, "First");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    public void createAndShowGUI() {
        this.frame = new JDialog();
        this.frame.setTitle("Exporting (" + (this.getCurrentValue() + 1) + "/" + this.getMaxValue() + ")...");
        this.frame.setModal(true);
        this.frame.setDefaultCloseOperation(2);
        this.setOpaque(true);
        this.frame.setContentPane(this);
        this.task = new Task();
        this.task.setBar(this);
        this.task.addPropertyChangeListener(this);
        this.task.execute();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void hideGUI() {
        this.frame.setVisible(false);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(int currentValue) {
        this.currentValue = currentValue;
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        if (destFile.exists()) {
            return;
        }
        destFile.createNewFile();
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        private ExportFullProgressBarDialog bar;

        Task() {
        }

        @Override
        public Void doInBackground() throws Exception {
            System.out.println("Full Export Started");
            try {
                File tempFolder = new File(String.valueOf(ExportFullProgressBarDialog.this.folder.getName().replace(".", "")) + File.separator);
                tempFolder.mkdirs();
                if (LegendaryCardMakerFrame.lcmf.lcm.dbImagePath != null) {
                    File file = new File(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + new File(LegendaryCardMakerFrame.lcmf.lcm.dbImagePath).getName());
                    try {
                        ExportFullProgressBarDialog.this.copyFile(new File(LegendaryCardMakerFrame.lcmf.lcm.dbImagePath), file);
                        LegendaryCardMakerFrame.lcmf.lcm.dbImagePath = new File(LegendaryCardMakerFrame.lcmf.lcm.dbImagePath).getName();
                    }
                    catch (IOException e1) {
                        LegendaryCardMakerFrame.lcmf.lcm.dbImagePath = null;
                    }
                }
                if (LegendaryCardMakerFrame.lcmf.lcm.dfImagePath != null) {
                    File file = new File(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + new File(LegendaryCardMakerFrame.lcmf.lcm.dfImagePath).getName());
                    try {
                        ExportFullProgressBarDialog.this.copyFile(new File(LegendaryCardMakerFrame.lcmf.lcm.dfImagePath), file);
                        LegendaryCardMakerFrame.lcmf.lcm.dfImagePath = new File(LegendaryCardMakerFrame.lcmf.lcm.dfImagePath).getName();
                    }
                    catch (IOException e1) {
                        LegendaryCardMakerFrame.lcmf.lcm.dfImagePath = null;
                    }
                }
                for (Hero hero : ((ExportFullProgressBarDialog)ExportFullProgressBarDialog.this).lcm.heroes) {
                    for (HeroCard heroCard : hero.cards) {
                        if (heroCard.imagePath == null) continue;
                        File newFile2 = new File(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + new File(heroCard.imagePath).getName());
                        try {
                            ExportFullProgressBarDialog.this.copyFile(new File(heroCard.imagePath), newFile2);
                            heroCard.imagePath = new File(heroCard.imagePath).getName();
                        }
                        catch (IOException e1) {
                            heroCard.imagePath = null;
                        }
                    }
                    if (hero.imagePath != null) {
                        File file = new File(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + new File(hero.imagePath).getName());
                        try {
                            ExportFullProgressBarDialog.this.copyFile(new File(hero.imagePath), file);
                            hero.imagePath = new File(hero.imagePath).getName();
                        }
                        catch (IOException e1) {
                            hero.imagePath = null;
                        }
                    }
                    ExportFullProgressBarDialog.this.frame.setTitle("Exporting (" + (ExportFullProgressBarDialog.this.getCurrentValue() + 1) + "/" + ExportFullProgressBarDialog.this.getMaxValue() + ")...");
                    ExportFullProgressBarDialog exportFullProgressBarDialog = ExportFullProgressBarDialog.this;
                    int n = exportFullProgressBarDialog.currentValue;
                    exportFullProgressBarDialog.currentValue = n + 1;
                    this.setProgress(n);
                }
                for (Villain villain : ((ExportFullProgressBarDialog)ExportFullProgressBarDialog.this).lcm.villains) {
                    for (VillainCard villainCard : villain.cards) {
                        if (villainCard.imagePath == null) continue;
                        File newFile = new File(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + new File(villainCard.imagePath).getName());
                        try {
                            ExportFullProgressBarDialog.this.copyFile(new File(villainCard.imagePath), newFile);
                            villainCard.imagePath = new File(villainCard.imagePath).getName();
                        }
                        catch (IOException e1) {
                            villainCard.imagePath = null;
                        }
                    }
                    if (villain.imagePath != null) {
                        File file = new File(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + new File(villain.imagePath).getName());
                        try {
                            ExportFullProgressBarDialog.this.copyFile(new File(villain.imagePath), file);
                            villain.imagePath = new File(villain.imagePath).getName();
                        }
                        catch (IOException e1) {
                            villain.imagePath = null;
                        }
                    }
                    ExportFullProgressBarDialog.this.frame.setTitle("Exporting (" + (ExportFullProgressBarDialog.this.getCurrentValue() + 1) + "/" + ExportFullProgressBarDialog.this.getMaxValue() + ")...");
                    ExportFullProgressBarDialog exportFullProgressBarDialog = ExportFullProgressBarDialog.this;
                    int n = exportFullProgressBarDialog.currentValue;
                    exportFullProgressBarDialog.currentValue = n + 1;
                    this.setProgress(n);
                }
                for (SchemeCard schemeCard : ((ExportFullProgressBarDialog)ExportFullProgressBarDialog.this).lcm.schemes) {
                    if (schemeCard.imagePath != null) {
                        File file = new File(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + new File(schemeCard.imagePath).getName());
                        try {
                            ExportFullProgressBarDialog.this.copyFile(new File(schemeCard.imagePath), file);
                            schemeCard.imagePath = new File(schemeCard.imagePath).getName();
                        }
                        catch (IOException e1) {
                            schemeCard.imagePath = null;
                        }
                    }
                    ExportFullProgressBarDialog.this.frame.setTitle("Exporting (" + (ExportFullProgressBarDialog.this.getCurrentValue() + 1) + "/" + ExportFullProgressBarDialog.this.getMaxValue() + ")...");
                    ExportFullProgressBarDialog exportFullProgressBarDialog = ExportFullProgressBarDialog.this;
                    int n = exportFullProgressBarDialog.currentValue;
                    exportFullProgressBarDialog.currentValue = n + 1;
                    this.setProgress(n);
                }
                for (CustomCard customCard : ((ExportFullProgressBarDialog)ExportFullProgressBarDialog.this).lcm.customCards) {
                    for (CustomElement customElement : customCard.template.elements) {
                        CustomElement eli;
                        if (customElement instanceof ElementImage) {
                            eli = (ElementImage)customElement;
                            if (eli.path != null) {
                                File newFile4 = new File(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + new File(eli.path).getName());
                                try {
                                    ExportFullProgressBarDialog.this.copyFile(new File(eli.path), newFile4);
                                    eli.path = new File(eli.path).getName();
                                }
                                catch (IOException e1) {
                                    eli.path = null;
                                }
                            }
                        }
                        if (!(customElement instanceof ElementBackgroundImage)) continue;
                        eli = (ElementBackgroundImage)customElement;
                        if (((ElementBackgroundImage)eli).path == null) continue;
                        File newFile = new File(String.valueOf(tempFolder.getAbsolutePath()) + File.separator + new File(((ElementBackgroundImage)eli).path).getName());
                        try {
                            ExportFullProgressBarDialog.this.copyFile(new File(((ElementBackgroundImage)eli).path), newFile);
                            ((ElementBackgroundImage)eli).path = new File(((ElementBackgroundImage)eli).path).getName();
                        }
                        catch (IOException e1) {
                            ((ElementBackgroundImage)eli).path = null;
                        }
                    }
                    ExportFullProgressBarDialog.this.frame.setTitle("Exporting (" + (ExportFullProgressBarDialog.this.getCurrentValue() + 1) + "/" + ExportFullProgressBarDialog.this.getMaxValue() + ")...");
                    ExportFullProgressBarDialog exportFullProgressBarDialog = ExportFullProgressBarDialog.this;
                    int n = exportFullProgressBarDialog.currentValue;
                    exportFullProgressBarDialog.currentValue = n + 1;
                    this.setProgress(n);
                }
                ExportFullProgressBarDialog.this.lcm.saveExpansion(true, String.valueOf(tempFolder.getAbsolutePath()) + File.separator + new File(((ExportFullProgressBarDialog)ExportFullProgressBarDialog.this).lcm.currentFile).getName());
                ZipperHelper.createCBZ(String.valueOf(tempFolder.getAbsolutePath()) + File.separator, ExportFullProgressBarDialog.this.folder.getAbsolutePath());
                Iterator<Object> iterator = tempFolder.listFiles();
                int n = ((File[])iterator).length;
                int n2 = 0;
                while (n2 < n) {
                    Iterator<Object> iterator2 = iterator[n2];
                    ((File)((Object)iterator2)).delete();
                    ++n2;
                }
                tempFolder.delete();
                ExportFullProgressBarDialog.this.lcm.processInput(((ExportFullProgressBarDialog)ExportFullProgressBarDialog.this).lcm.currentFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Full Export Finished");
            return null;
        }

        @Override
        public void done() {
            this.bar.hideGUI();
        }

        public ExportFullProgressBarDialog getBar() {
            return this.bar;
        }

        public void setBar(ExportFullProgressBarDialog bar) {
            this.bar = bar;
        }
    }
}

